/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KillTask
extends Task {
    public static final ResourceLocation ZOMBIE = new ResourceLocation("minecraft:zombie");
    public ResourceLocation entity = ZOMBIE;
    public long value = 100L;

    public KillTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("entity", this.entity.toString());
        nbt.func_74772_a("value", this.value);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.entity = new ResourceLocation(nbt.func_74779_i("entity"));
        this.value = nbt.func_74763_f("value");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.entity.toString(), Short.MAX_VALUE);
        buffer.func_179254_b(this.value);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.entity = new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE));
        this.value = buffer.func_150792_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ArrayList ids = new ArrayList(Registry.field_212629_r.func_148742_b());
        config.addEnum("entity", (Object)this.entity, v -> {
            this.entity = v;
        }, NameMap.of((Object)ZOMBIE, ids).nameKey(v -> "entity." + v.func_110624_b() + "." + v.func_110623_a()).icon(v -> {
            SpawnEggItem item = SpawnEggItem.func_200889_b((EntityType)((EntityType)Registry.field_212629_r.func_82594_a(v)));
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.field_221671_bX));
        }).create(), (Object)ZOMBIE);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.task.ftbquests.kill.title", new Object[]{this.formatMaxProgress(), new TranslationTextComponent("entity." + this.entity.func_110624_b() + "." + this.entity.func_110623_a())});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        SpawnEggItem item = SpawnEggItem.func_200889_b((EntityType)((EntityType)Registry.field_212629_r.func_82594_a(this.entity)));
        return ItemIcon.getItemIcon((Item)(item != null ? item : Items.field_221671_bX));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void kill(TeamData teamData, LivingEntity e) {
        if (!teamData.isCompleted(this) && this.entity.equals((Object)Registries.getId((Object)e.func_200600_R(), (RegistryKey)Registry.field_239713_n_))) {
            teamData.addProgress(this, 1L);
        }
    }
}

